<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 07.01.14 10:13
 */

namespace VM\ApiBundle\Command;

use Doctrine\ORM\EntityManager;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use VM\ApiBundle\Entity\Application;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Services\PasswordEncoder;

class GameCreateTeachersCommand extends ContainerAwareCommand
{

    /**
     * @var EntityManager
     */
    protected $EntityManager;


    protected function configure()
    {
        $this
            ->setName('game:create:teachers')
            ->setDescription('Dodaje konta nauczycieli o zadanym przedrostku, ilości i ustalonym haśle')
            ->addOption('prefix', null, InputOption::VALUE_REQUIRED, 'Prefix loginu', 'vm')
            ->addOption('sufix', null, InputOption::VALUE_REQUIRED, 'Sufix loginu (liczba od której zacząć generować loginy)', 1)
            ->addOption('number', null, InputOption::VALUE_REQUIRED, 'Ilość kont do wygenerowania', 10)
            ->addOption('password', null, InputOption::VALUE_REQUIRED, 'Hasło - jeśli parametr będzie miał wartość false, to hasła zostaną wygnerowane', false)
            ->addOption('roles', null, InputOption::VALUE_REQUIRED, 'Role użytkownika', 'ROLE_TEACHER')
            ->addOption('application', null, InputOption::VALUE_REQUIRED, 'Aplikacja dla której konta mają być wygenerowane', 'GAME')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try
        {
            $PasswordEncoder = new PasswordEncoder();

            $prefix = $input->getOption('prefix');
            $sufix = $input->getOption('sufix');
            $number = $input->getOption('number');
            $password = $input->getOption('password');
            $roles = $input->getOption('roles');
            $rolesArray = explode(',', $roles);
            $application = $input->getOption('application');


            $output->writeln('Rozpoczynam generowanie <info>' . $number . '</info> kont dla aplikacji <info>' . $application . '</info>');


            $Application = $this->getApp('GAME');


            for($i = $sufix; $i < $number + $sufix; $i++)
            {
                $User = new User();
                $User->setName($prefix . $i);
                $User->setSurname($prefix . $i);
                $User->setUsername($prefix . $i . '@vm.pl');
                $User->setEmail($prefix . $i . '@vm.pl');

                $salt = md5(rand(1, 10000000));
                $User->setSalt($salt);
                $User->setEnabled(true);

                $pass = ($password == false) ? md5($salt . $i) : $password;

                $User->setPlainPassword(md5($pass));
//                $User->setPlainPassword($PasswordEncoder->encodePassword($pass, $salt));

                $this->getEntityManager()->persist($User);

                foreach($rolesArray as $roleSymbol)
                {
                    $ApplicationRole = $this->getApplicationRole($Application, $roleSymbol);
                    $User->addAppRole($ApplicationRole);
                    $ApplicationRole->addUser($User);
                }
                $output->writeln($prefix . $i . '@vm.pl' . "\t". $pass);
            }

            $this->getEntityManager()->flush();
        }
        catch(\Exception $Exception)
        {
            $output->writeln('<error>' . $Exception->getCode() . ' - ' . $Exception->getMessage() .  ' </error>');
        }
    }


    /**
     * @return EntityManager
     */
    protected function getEntityManager()
    {
        return $this->EntityManager = $this->getContainer()->get('doctrine.orm.entity_manager');
    }


    /**
     * @param $symbol
     * @return Application
     * @throws \Exception
     */
    protected function getApp($symbol)
    {
        $Application = $this->getEntityManager()->getRepository('VMApiBundle:Application')->findOneBySymbol($symbol);
        if(empty($Application))
        {
            throw new \Exception('Application is not exist');
        }
        return $Application;
    }


    /**
     * @param Application $Application
     * @param $roleSymbol
     * @return \VM\ApiBundle\Entity\ApplicationRole
     * @throws \Exception
     */
    protected function getApplicationRole(Application $Application, $roleSymbol)
    {
        $ApplicationRole = $this->getEntityManager()->getRepository('VMApiBundle:ApplicationRole')->findOneBy(array('appId' => $Application->getId(), 'symbol' => $roleSymbol));
        if(empty($ApplicationRole))
        {
            throw new \Exception('Role is not exist in application');
        }
        return $ApplicationRole;
    }
} 